/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.portals;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class BNPortalShape {
    private static final Direction[] DIR_X = new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST};
    private static final Direction[] DIR_Z = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH};
    public static final int MAX_SEARCH_DIST = 21;
    private final LevelAccessor levelAccessor;
    private final BlockPos blockPos;
    private final Direction.Axis axis;
    BlockPos.MutableBlockPos min;
    BlockPos.MutableBlockPos max;
    private final boolean valid;
    private final List<BlockPos> portalBlocks = new LinkedList<BlockPos>();
    private int numPortalBlocks = 0;
    private static final BlockPos[] stack = new BlockPos[63];

    public BNPortalShape(LevelAccessor levelAccessor, BlockPos blockPos, Direction.Axis axis) {
        this.levelAccessor = levelAccessor;
        this.blockPos = blockPos;
        this.axis = axis;
        this.valid = axis.equals((Object)Direction.Axis.X) ? this.getPortalBlocks(blockPos, DIR_X) : this.getPortalBlocks(blockPos, DIR_Z);
    }

    private boolean getPortalBlocks(BlockPos blockPos, Direction[] directions) {
        this.portalBlocks.clear();
        BlockState[][] states = new BlockState[42][42];
        byte[][] mask = new byte[42][42];
        this.min = blockPos.m_122032_();
        this.max = blockPos.m_122032_();
        boolean nextStackPos = false;
        Stack<BlockPos> todo = new Stack<BlockPos>();
        todo.add(blockPos);
        while (!todo.isEmpty()) {
            BlockPos p = (BlockPos)todo.pop();
            BlockState tstate = this.levelAccessor.m_8055_(p);
            if (tstate.m_60713_(Blocks.f_50142_)) {
                ++this.numPortalBlocks;
            }
            this.portalBlocks.add(p);
            if (p.m_123341_() < this.min.m_123341_()) {
                this.min.m_142451_(p.m_123341_());
            }
            if (p.m_123342_() < this.min.m_123342_()) {
                this.min.m_142448_(p.m_123342_());
            }
            if (p.m_123343_() < this.min.m_123343_()) {
                this.min.m_142443_(p.m_123343_());
            }
            if (p.m_123341_() > this.max.m_123341_()) {
                this.max.m_142451_(p.m_123341_());
            }
            if (p.m_123342_() > this.max.m_123342_()) {
                this.max.m_142448_(p.m_123342_());
            }
            if (p.m_123343_() > this.max.m_123343_()) {
                this.max.m_142443_(p.m_123343_());
            }
            for (Direction d : directions) {
                BlockPos pp = p.m_5484_(d, 1);
                if (this.portalBlocks.contains(pp)) continue;
                if (Math.abs(pp.m_123341_() - blockPos.m_123341_()) > 21 || Math.abs(pp.m_123343_() - blockPos.m_123343_()) > 21 || Math.abs(pp.m_123342_() - blockPos.m_123342_()) > 21) {
                    this.portalBlocks.clear();
                    return false;
                }
                BlockState state = this.levelAccessor.m_8055_(pp);
                if (BNPortalShape.isEmpty(state)) {
                    todo.add(pp);
                    continue;
                }
                if (BNPortalShape.isFrame(state)) continue;
                this.portalBlocks.clear();
                return false;
            }
        }
        return true;
    }

    public BlockPos calculateBottomLeft(BlockPos blockPos) {
        return this.valid ? this.min : null;
    }

    public int calculateWidth() {
        if (this.axis == Direction.Axis.X) {
            return this.valid ? this.max.m_123341_() - this.min.m_123341_() : 0;
        }
        if (this.axis == Direction.Axis.Z) {
            return this.valid ? this.max.m_123343_() - this.min.m_123343_() : 0;
        }
        return 0;
    }

    public int calculateHeight() {
        if (this.axis == Direction.Axis.X) {
            return this.valid ? this.max.m_123342_() - this.min.m_123342_() : 0;
        }
        if (this.axis == Direction.Axis.Z) {
            return this.valid ? this.max.m_123342_() - this.min.m_123342_() : 0;
        }
        return 0;
    }

    private static boolean isFrame(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50080_) || blockState.m_204336_(CommonBlockTags.NETHER_PORTAL_FRAME);
    }

    private static boolean isEmpty(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13076_) || blockState.m_60713_(Blocks.f_50142_);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void createPortalBlocks() {
        BlockState blockState = (BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis);
        this.portalBlocks.forEach(p -> this.levelAccessor.m_7731_(p, blockState, 18));
    }

    public boolean isComplete() {
        return this.valid && this.numPortalBlocks == this.portalBlocks.size();
    }
}

